'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    
    'Zahlenformat fr Dauer einstellen
    Me.Dauer_Minuten_Re.Visible = False
    Me.Dauer_Std_Re.Visible = False
    Me.Dauer_StdMin_Re.Visible = False
    Select Case FormatTermindauer
        Case 0      'Minuten  (Bsp.: 105)
            Me.Dauer_Minuten_Re.Visible = True
        Case 4      'Dezimalstunden  (1,75)
            Me.Dauer_Std_Re.Visible = True
        Case 8      'Std:Min  (01:45)
            Me.Dauer_StdMin_Re.Visible = True
        Case Else
            Me.Dauer_Minuten_Re.Visible = True
    End Select
    
    'aktuelles Whrungsformat des Systems einstellen
    Me.Std_Satz.Format = "Currency"
    Me.Text42.Format = "Currency"                       'Rechnungszeile bisheriges Netto
    Me.Text38.Format = "Currency"                       'Rechnungszeile Netto
    Me.Text77.Format = "Currency"                       'Fubereich bisheriges Netto
    Me.Text75.Format = "Currency"                       'Fubereich Netto-Summe
    Me.km_Preis_Test.Format = "Currency"
    Me.km_Netto_bisher_Test.Format = "Currency"
    Me.km_Netto_Test.Format = "Currency"
    
    'Nachkommastellen fr den Stundensatz einstellen
    Me.Std_Satz.DecimalPlaces = NachkommaStdSatz
    Me.km_Preis_Test.DecimalPlaces = NachkommaStdSatz
End Sub
